/////////////////////////////////////////////////////////////
// CINEMA SDK : PLUGIN      															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_BASEPLUGIN_H
#define __C4D_BASEPLUGIN_H

#include "ge_math.h"
#include "c4d_basedata.h"
#include "c4d_baselist.h"

class String;

#define PLUGINFLAG_HIDE						(1<<29)
#define PLUGINFLAG_SMALLNODE			(1<<30)
#define PLUGINFLAG_COFFEE					(1<<31)
#define PLUGINFLAG_HIDEPLUGINMENU	(1<<28)

#ifdef __MAC
	#define C4DPL_MEMBERMULTIPLIER	3
#else
	#define	C4DPL_MEMBERMULTIPLIER	1
#endif

struct BASEPLUGIN
{
	LONG	info;

	void	(BaseData::*Destructor)(void);

	void*	reserved[(8-1)*C4DPL_MEMBERMULTIPLIER-1];
};

struct STATICPLUGIN : public BASEPLUGIN
{
	BaseData *adr;

	void*	reserved[(8-0)*C4DPL_MEMBERMULTIPLIER-1];
};

#ifndef __API_INTERN__

#include "c4d_baselist.h"

class BasePlugin : public BaseList2D
{
	public:
		BasePlugin *GetNext    (void) { return (BasePlugin*)AtCall(GetNext)(); }
		BasePlugin *GetPred    (void) { return (BasePlugin*)AtCall(GetPred)(); }
		BasePlugin *GetUp      (void) { return (BasePlugin*)AtCall(GetUp)(); }
		BasePlugin *GetDown    (void) { return (BasePlugin*)AtCall(GetDown)(); }
		BasePlugin *GetDownLast(void) { return (BasePlugin*)AtCall(GetDownLast)(); }

		// LONG GetType() inherited
		void*			GetPluginStructure();
		LONG			GetInfo();
		Filename	GetFilename();
		LONG			GetID();
};

BasePlugin* FindPlugin(LONG id, LONG type=0);
BasePlugin*	GetFirstPlugin();

#else
	#include "plugin.h"
#endif

#endif
